<!-- Main content -->
<x-admin.contents>
    <x-slot:title>{{ $data['title'] }}</x-slot:title>
    <x-slot:menuOpen>{{ $data['menuOpen'] }} </x-slot:menuOpen>
    <x-slot:menuActive>{{ $data['menuActive'] }} </x-slot:menuActive>
    <x-slot:page>{{ $data['page'] }}</x-slot:page>
    <x-slot:head>
        <link rel="stylesheet" href="{{ asset('') }}assets/admin/plugins/icheck-bootstrap/icheck-bootstrap.min.css">
        <link rel="stylesheet"
            href="{{ asset('assets/') }}/admin/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
        <link rel="stylesheet"
            href="{{ asset('assets/') }}/admin/plugins/datatables-responsive/css/responsive.bootstrap4.min.css">
        <link rel="stylesheet"
            href="{{ asset('assets/') }}/admin/plugins/datatables-buttons/css/buttons.bootstrap4.min.css">
        <link rel="stylesheet" href="{{ asset('') }}assets/admin/plugins/sweetalert2/sweetalert2.min.css">
    </x-slot:head>


    <section class="content">

        <!-- Default box -->
        <div class="row">
            <div class="col-lg-8">
                <x-message></x-message>
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fa fa-server text-primary"></i> {{ $data['page'] }}</h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-bordered table-hover myTable tab">
                            <thead>
                                <tr>
                                    <th width="3%">No</th>
                                    <th>Kode Ongkir</th>
                                    <th>Berat </th>
                                    <th>Harga </th>
                                    <th>Daerah / Rute</th>
                                    <th width="20%">Opsi</th>
                                </tr>
                            </thead>
                            <tbody id="view">
                                @forelse ($ongkir as $s)
                                    <tr>
                                        <td class="text-center">{{ $no++ }}</td>
                                        <td>{{ $s->kd_ongkir }}</td>
                                        <td>Per {{ number_format($s->berat, 0, ',', '.') }} Kg</td>
                                        <td>{{ number_format($s->harga, 0, ',', '.') }}</td>
                                        <td>{{ $s->rute }}</td>
                                        <td class="text-center">
                                            <button class="btn btn-primary btn-sm mb-0 mt-0 edit"
                                                data-id="{{ $s->id }}" data-toggle="modal"
                                                data-target="#edit{{ $s->id }}">
                                                <i class="fa fa-edit mr-2"></i> Edit
                                            </button>
                                            <button class="btn btn-danger btn-sm mb-0 mt-0 hapus"
                                                data-id="{{ $s->id }}" data-nm="{{ $s->kd_ongkir }}">
                                                <i class="fa fa-trash mr-1"></i> Hapus
                                            </button>

                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center text-danger"> Data Ongkir masih
                                            kosong.
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h3 class="card-title "><i class="fa fa-database text-primary"></i> Input {{ $data['page'] }}
                        </h3>
                    </div>
                    <form action="{{ route('ongkir.store') }}" method="post">
                        <div class="card-body">
                            @csrf
                            <div class="form-group">
                                <label>Kode Ongkir</label>
                                <input type="text" name="kd_ongkir" class="form-control" placeholder="Kode Ongkir"
                                    autofocus required value="{{ old('kd_ongkir') }}">
                                @error('kd_ongkir')
                                    <small class="text-danger mt-2">
                                        {{ $message }}
                                    </small>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label>Berat (Kg)</label>
                                <input type="text" name="berat" class="form-control numbers" placeholder="0 Kg"
                                    required value="{{ old('berat') }}">
                                @error('berat')
                                    <small class="text-danger mt-2">
                                        {{ $message }}
                                    </small>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label>Harga (/Kg)</label>
                                <input type="text" name="harga" class="form-control numbers" placeholder="Rp. 0"
                                    required value="{{ old('harga') }}">
                                @error('harga')
                                    <small class="text-danger mt-2">
                                        {{ $message }}
                                    </small>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label>Daerah / Rute Ongkir</label>
                                <textarea name="rute" id="" class="form-control" placeholder="Jalan, Perumahan, Gang, Dll...."></textarea>
                                @error('rute')
                                    <small class="text-danger mt-2">
                                        {{ $message }}
                                    </small>
                                @enderror
                            </div>

                        </div>
                        <div class="card-footer">
                            <button type="reset" class="btn btn-default"><i class="fa fa-sync-alt"></i>
                                Reset</button>
                            <button class="btn btn-primary float-right"><i class="fa fa-save"></i> Simpan</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <!-- /.card -->

    </section>

    @foreach ($ongkir as $u)
        <div class="modal fade" id="edit{{ $u->id }}">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header bg-primary ">
                        <h4 class="modal-title">Edit Data</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form action="edit-ongkir" method="POST">
                        <div class="modal-body">
                            @csrf
                            @method('put')
                            <input type="hidden" name="id" id="" value="{{ $u->id }}">
                            <input type="hidden" name="kdlama" id="" value="{{ $u->kd_ongkir }}">
                            <div class="form-group">
                                <label>Kode Ongkir</label>
                                <input type="text" name="kd_ongkir" class="form-control" placeholder="Kode Ongkir"
                                    autofocus required value="{{ $u->kd_ongkir }}">
                                @error('kd_ongkir')
                                    <small class="text-danger mt-2">
                                        {{ $message }}
                                    </small>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label>Berat (Kg)</label>
                                <input type="text" name="berat" class="form-control numbers" placeholder="0 Kg"
                                    required value="{{ $u->berat }}">
                                @error('berat')
                                    <small class="text-danger mt-2">
                                        {{ $message }}
                                    </small>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label>Harga (/Kg)</label>
                                <input type="text" name="harga" class="form-control numbers"
                                    placeholder="Rp. 0" required value="{{ $u->harga }}">
                                @error('harga')
                                    <small class="text-danger mt-2">
                                        {{ $message }}
                                    </small>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label>Daerah / Rute Ongkir</label>
                                <textarea name="rute" id="" class="form-control" placeholder="Jalan, Perumahan, Gang, Dll....">{{ $u->rute }}</textarea>
                                @error('rute')
                                    <small class="text-danger mt-2">
                                        {{ $message }}
                                    </small>
                                @enderror
                            </div>


                        </div>
                        <div class="modal-footer justify-content-between">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary"><i class="fa fa-save"></i> Simpan</button>
                        </div>
                    </form>
                </div>
                <!-- /.modal-content -->
            </div>
            <!-- /.modal-dialog -->
        </div>
    @endforeach


    <x-slot:foot>
        <script src="{{ asset('assets/') }}/admin/plugins/bs-custom-file-input/bs-custom-file-input.min.js"></script>
        <script src="{{ asset('assets/') }}/admin/plugins/datatables/jquery.dataTables.min.js"></script>
        <script src="{{ asset('assets/') }}/admin/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
        <script src="{{ asset('assets/') }}/admin/plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
        <script src="{{ asset('assets/') }}/admin/plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
        <script src="{{ asset('') }}assets/admin/plugins/sweetalert2/sweetalert2.all.min.js"></script>
        <script>
            $(function() {
                $('.myTable').DataTable();
            });

            $('#view').on('click', '.hapus', function() {
                var id = $(this).attr('data-id');
                var nama = $(this).attr('data-nm');

                Swal.fire({
                    title: "Apa anda yakin?",
                    text: "Ongkir  dengan Kode ( " + nama +
                        " ) & data yang berkaitan dengan Data tersebut akan di hapus!",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#3085d6",
                    cancelButtonColor: "#d33",
                    confirmButtonText: "Ya, Hapus!"
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.location.href = "delete-ongkir/" + id;
                    }
                });

            });
        </script>
    </x-slot:foot>
</x-admin.contents>
